import os
import sys
import pysam


alignments = pysam.AlignmentFile(sys.stdin)
output = pysam.AlignmentFile(sys.stdout, "w", template=alignments)

for alignment1 in alignments:
    alignment2 = next(alignments)
    assert alignment1.query_name == alignment2.query_name
    alignment1.is_read1 = True
    alignment2.is_read2 = True
    alignment1.is_paired = True
    alignment2.is_paired = True
    if alignment1.is_unmapped or alignment2.is_unmapped:
        alignment1.is_unmapped = True
        alignment2.is_unmapped = True
    else:
        alignment1.is_proper_pair = True
        alignment2.is_proper_pair = True
        if alignment1.is_reverse:
            assert not alignment2.is_reverse
            alignment1.mate_is_reverse = False
            alignment2.mate_is_reverse = True
        else:
            assert alignment2.is_reverse
            alignment1.mate_is_reverse = True
            alignment2.mate_is_reverse = False
    output.write(alignment1)
    output.write(alignment2)

